package co.com.qvision.test.stepdefinitions;

import co.com.qvision.test.questions.EncontroPalabra;
import co.com.qvision.test.tasks.*;
import co.com.qvision.test.userinterface.HomeGoogle;
import cucumber.api.java.Before;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import cucumber.api.java.es.Cuando;
import cucumber.api.java.es.Dado;
import cucumber.api.java.es.Entonces;
import net.serenitybdd.screenplay.actors.OnStage;
import net.serenitybdd.screenplay.actors.OnlineCast;

import static net.serenitybdd.screenplay.actors.OnStage.theActorCalled;
import static net.serenitybdd.screenplay.actors.OnStage.theActorInTheSpotlight;
import static net.serenitybdd.screenplay.GivenWhenThen.seeThat;
import static org.hamcrest.Matchers.is;

public class BuscarPalabraGoogleStepDefinitions {
    @Before
    public void set_the_stage() {
        OnStage.setTheStage(new OnlineCast());
    }

    @Dado("^El usuario ingresa al navegador google$")
    public void ana_ingresa_al_navegador_de_google() {
    theActorCalled("Ana").attemptsTo(
            GoogleHomeTask.openUrl(HomeGoogle.UrlGoogle)
    );
    }

    @Cuando("^ingresa la palabra a buscar$")
    public void ana_ingresa_la_palabra_a_buscar() {
        theActorInTheSpotlight().attemptsTo(BuscarPalabraGoogleTasks.buscar());
    }


    @Entonces("^verifica la palabra buscada$")
    public void se_verifica_la_palabra_buscada() {
        theActorInTheSpotlight().should(seeThat(" La busqueda ",EncontroPalabra.verificar(), is(true)).because(" %s deberia ser %s "));
    }

}
