package starter.winium.util;

import java.io.IOException;
import java.net.URL;

import org.openqa.selenium.WebDriver;

import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.DriverSource;
import starter.winium.exception.NoSePudoInstanciarElDriver;

import org.openqa.selenium.winium.DesktopOptions;
import org.openqa.selenium.winium.WiniumDriver;

public class CustomWiniumDriver implements DriverSource {

	public CustomWiniumDriver() {
		super();
	}

	@Override
	public WebDriver newDriver() {

		try {
			EnvironmentVariables vA = Injectors.getInjector().getInstance(EnvironmentVariables.class);
			String directorio = EnvironmentSpecificConfiguration.from(vA).getProperty("windows.program.path");

			DesktopOptions option = new DesktopOptions();
			option.setApplicationPath(directorio);
			option.setDebugConnectToRunningApp(false);
			option.setLaunchDelay(1);

			return new WiniumDriver(new URL("http://localhost:9999"), option);

		} catch (IOException e) {
			throw new NoSePudoInstanciarElDriver("No se pudo instanciar el driver $", e);
		}
	}

	@Override
	public boolean takesScreenshots() {
		return true;
	}
}