package starter.winium.hook;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import java.io.File;

import io.cucumber.java.After;
import io.cucumber.java.Before;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;

public class ServidorWinium {

	private Process proceso;
	private EnvironmentVariables variablesDeAmbiente = Injectors.getInjector().getInstance(EnvironmentVariables.class);

	@Before
	public void iniciarServidorWinium() throws IOException, InterruptedException {
		String directorio = EnvironmentSpecificConfiguration.from(variablesDeAmbiente).getProperty("servidor.winium.path");
		ProcessBuilder constructor = new ProcessBuilder(new File(directorio).getAbsolutePath());
		proceso = constructor.start();
		proceso.waitFor(3, TimeUnit.SECONDS);
	}

	@After
	public void terminarServidorWinium() {
		proceso.destroy();
	}
}